﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCCPASEL")]

public partial class ucCPASelection : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

     /// <summary>
    /// show the selection popup
    /// </summary>
    public void Show()
    {
        wndSelectCPA.Show();
    }

    /// <summary>
    /// initialize the selection dialog
    /// </summary>
    /// <returns></returns>
    public bool InitializeControl()
    {
        //get the clinical program area data set
        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetCPADS(BaseMstr,
                                  BaseMstr.RegionID,
                                  BaseMstr.SiteID);
        
        //load the store
        storCPA.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        if (!CDataUtils2.IsEmpty(ds))
        {
            //load the store
            CDataConverter cdc = new CDataConverter();
            storCPA.SetDataFromJson(cdc.GetJsonDSString(ds));
        }

        return true;
    }

    /// <summary>
    /// page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {

    }
}